!     This script is convert ncl binary into vsource.th     
!     Recommend to use intel ifort
!     ifort -O2 -o cvt2th cvt2th.f90
!     Input: dim.dat, vsource_np.bin (generated by ncl),hgrid.cpp,itp_A
!     Output: vsource.th
      real,allocatable :: vsource_np(:),vsource(:),area(:)
      integer,allocatable :: i34(:),elnode(:,:)
      integer ne,np,nnp
      real dt

      open(10,file='dim.dat')
      read(10,*) nt
      read(10,*) nnp
      read(10,*) dt
      close(10)
      allocate(vsource_np(nnp))

      open(10,file='hgrid.cpp')
      read(10,*) 
      read(10,*) ne,np
      if (np.ne.nnp) then
         write(*,*) ' ncl output dim is not match with hgrid.cpp'
         stop
      end if
      allocate(i34(ne),elnode(4,ne),vsource(ne),area(ne))
      do i=1,np
         read(10,*)
      end do
      do i=1,ne
         read(10,*) j,i34(i),elnode(1:i34(i),i)
      end do
      close(10)

      open(10,file='itp_A')
      do i=1,ne
         read(10,*) area(i)
      end do


      open(11,file='vsource_np.bin',form='unformatted')
      open(21,file='vsource.th',status='replace')


      do l=1,nt
         read(11) vsource_np
         do i=1,ne
            if (i34(i)==3) then ! tri
               vsource(i)=(vsource_np(elnode(1,i))+vsource_np(elnode(2,i))+vsource_np(elnode(3,i)))/3.*area(i)/1000.
            elseif (i34(i)==4) then ! quad
               vsource(i)=(vsource_np(elnode(1,i))+vsource_np(elnode(2,i))+vsource_np(elnode(3,i))+vsource_np(elnode(4,i)))/4.*area(i)/1000.
            end if
         end do
         write(21,99) (l-1)*dt,vsource(:)
      end do

      deallocate(vsource,vsource_np)
 99   format(f9.0,<ne>(f8.3)) !<ne> only work for intel compiler

      end
