/*
 * ACE/vis - Visualization of Flow and Transport
 *
 * Paul J. Turner and Antonio M. Baptista
 *
 * Copyright 1990-2003 Oregon Health and Science University
 * All Rights Reserved
 *
 */

/* $Id: bitmaps.h,v 1.2 2003/07/24 15:44:06 pturner Exp $
 *
 */
#define auto_width 16
#define auto_height 16
static char auto_bits[] = {
    0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x3c, 0x00, 0x3c, 0x06, 0x66, 0x1e,
    0x7e, 0x76, 0xc3, 0x76, 0xc3, 0x06, 0x00, 0x1c, 0x00, 0x78, 0x00, 0x60,
    0x00, 0x66, 0x00, 0x7e, 0x00, 0x78, 0x00, 0x00
};

#define bbound_width 16
#define bbound_height 16
static char bbound_bits[] = {
    0xf8, 0x00, 0x8c, 0x03, 0x04, 0x06, 0x04, 0x0c, 0x04, 0x08, 0x7c, 0x30,
    0x40, 0x20, 0x40, 0x20, 0x60, 0x20, 0x38, 0x20, 0x0c, 0x20, 0x04, 0x20,
    0x0c, 0x20, 0x78, 0x20, 0xc0, 0x23, 0x00, 0x3e
};

#define bgrid_width 16
#define bgrid_height 16
static char bgrid_bits[] = {
    0x00, 0x00, 0xfe, 0x7f, 0x06, 0x60, 0x0a, 0x50, 0x12, 0x48, 0x22, 0x44,
    0x42, 0x42, 0x82, 0x41, 0x82, 0x41, 0x42, 0x42, 0x22, 0x44, 0x12, 0x48,
    0x0a, 0x50, 0x06, 0x60, 0xfe, 0x7f, 0x00, 0x00
};

#define buildp_width 16
#define buildp_height 16
static char buildp_bits[] = {
    0x00, 0x00, 0x06, 0xc0, 0x06, 0xc0, 0x00, 0x00, 0x00, 0x06, 0x00, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0c, 0x60, 0x0c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0c, 0x03, 0x0c, 0x03, 0x00
};

#define depthn_width 16
#define depthn_height 16
static char depthn_bits[] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x01, 0x00, 0x1f, 0x00, 0x11, 0x3c, 0x11, 0x3c, 0x11, 0x3c, 0x11,
    0x3c, 0x11, 0x3c, 0x11, 0x00, 0x00, 0x00, 0x00
};

#define down_width 16
#define down_height 16
static char down_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01,
    0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xf8, 0x0f, 0xf0, 0x07,
    0xe0, 0x03, 0xc0, 0x01, 0x80, 0x00, 0x00, 0x00
};

#define ebound_width 16
#define ebound_height 16
static char ebound_bits[] = {
    0xf8, 0x00, 0x8c, 0x03, 0x04, 0x06, 0x04, 0x0c, 0x04, 0x08, 0x7c, 0x30,
    0x40, 0x20, 0x40, 0x20, 0x60, 0x20, 0x38, 0x20, 0x0c, 0x20, 0x04, 0x20,
    0x0c, 0x20, 0x78, 0x20, 0xc0, 0x23, 0x00, 0x3e
};

#define elemn_width 16
#define elemn_height 16
static char elemn_bits[] = {
    0x00, 0x00, 0x00, 0x3e, 0x00, 0x22, 0x00, 0x22, 0x00, 0x3e, 0x00, 0x20,
    0x00, 0x20, 0x00, 0x22, 0xc0, 0x3e, 0xe0, 0x00, 0xb0, 0x00, 0x98, 0x00,
    0x8c, 0x00, 0x86, 0x00, 0x83, 0x00, 0xff, 0x00
};

#define elev_width 32
#define elev_height 32
#define elev_x_hot -1
#define elev_y_hot -1
static char elev_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x21, 0x13, 0x01, 0x00, 0xa7, 0x14, 0x01, 0x00, 0xa1, 0xa7, 0x00,
    0x00, 0xa1, 0xe0, 0x00, 0x00, 0x2f, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x00, 0xc0, 0x81, 0x83, 0x00,
    0x20, 0x00, 0x04, 0x01, 0x10, 0x00, 0x08, 0x02, 0x08, 0x00, 0x10, 0x04,
    0x08, 0xf8, 0x20, 0x04, 0x04, 0x04, 0x41, 0x08, 0x04, 0x02, 0x42, 0x18,
    0x04, 0x01, 0x84, 0x10, 0x04, 0x01, 0x84, 0x10, 0x04, 0x01, 0x84, 0x20,
    0x04, 0x01, 0x84, 0x20, 0x04, 0x01, 0x84, 0x20, 0x04, 0x02, 0x82, 0x20,
    0x08, 0x04, 0x81, 0x20, 0x08, 0xf8, 0x80, 0x20, 0x08, 0x00, 0x40, 0x20,
    0x10, 0x00, 0x20, 0x10, 0x30, 0x00, 0x10, 0x10
};

#define elevm_width 32
#define elevm_height 32
static char elevm_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfe, 0x03, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x00,
    0x00, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x00,
    0x00, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x00,
    0x00, 0x02, 0x02, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0xfe, 0x03, 0x00,
    0x00, 0xfe, 0x03, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0xfe, 0x03, 0x00,
    0x00, 0xfe, 0x03, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0xfe, 0x07, 0x00,
    0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x30, 0x00,
    0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x01,
    0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x06
};

#define expand_width 16
#define expand_height 16
static char expand_bits[] = {
    0x00, 0x00, 0xfe, 0x7f, 0xfe, 0x3f, 0x02, 0x18, 0x00, 0x0c, 0x00, 0x06,
    0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x00,
    0x0c, 0x40, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00
};

#define flows_width 32
#define flows_height 32
static char flows_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xf8, 0x00,
    0x00, 0x00, 0xbe, 0x00, 0x00, 0x80, 0x8f, 0x00, 0x00, 0xc0, 0x03, 0x00,
    0x00, 0xf0, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xf0, 0xff, 0x03,
    0x00, 0xf0, 0xff, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xc0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,
    0x00, 0xe0, 0x03, 0x00, 0x00, 0x80, 0x47, 0x00, 0x00, 0x00, 0xde, 0x00,
    0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xf8, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define grid_width 16
#define grid_height 16
static char grid_bits[] = {
    0x00, 0x00, 0xfe, 0x7f, 0x06, 0x60, 0x0a, 0x50, 0x12, 0x48, 0x22, 0x44,
    0x42, 0x42, 0x82, 0x41, 0x82, 0x41, 0x42, 0x42, 0x22, 0x44, 0x12, 0x48,
    0x0a, 0x50, 0x06, 0x60, 0xfe, 0x7f, 0x00, 0x00
};

#define gridf_width 16
#define gridf_height 16
static char gridf_bits[] = {
    0x80, 0xff, 0x80, 0x80, 0xe0, 0x80, 0xf8, 0x80, 0xbc, 0xff, 0x1e, 0x00,
    0x1e, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x07, 0x08, 0x1d, 0x08, 0x71, 0x08,
    0xc1, 0x09, 0x01, 0x0f, 0x01, 0x0c, 0xff, 0x0f
};

#define isol_width 16
#define isol_height 16
static char isol_bits[] = {
    0xf0, 0x00, 0xb8, 0x07, 0x0c, 0x0c, 0x06, 0x38, 0xc2, 0x61, 0x63, 0x43,
    0x21, 0xc4, 0x21, 0x88, 0x21, 0x88, 0x62, 0x88, 0xc2, 0x8f, 0x04, 0x80,
    0x0c, 0x80, 0x38, 0xc0, 0xe0, 0x60, 0x80, 0x3f
};

#define left_width 16
#define left_height 16
static char left_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x30, 0x00, 0x38, 0x00,
    0xfc, 0x3f, 0xfe, 0x3f, 0xfc, 0x3f, 0x38, 0x00, 0x30, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define noden_width 16
#define noden_height 16
static char noden_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7b, 0x00, 0x0a, 0x00, 0x7b,
    0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x7b, 0x00, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00
};

#define pathl_width 32
#define pathl_height 32
static char pathl_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00,
    0xc0, 0x03, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x60, 0x00, 0x00, 0x00, 0x40, 0x06, 0x00, 0x00, 0x80, 0x0f, 0xc0, 0x00,
    0x00, 0xff, 0xe0, 0x01, 0x00, 0x06, 0xff, 0x07, 0x00, 0x00, 0xc0, 0x0c,
    0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x80, 0x01, 0x00, 0x08, 0xc0, 0x03, 0x30, 0x0c, 0xc0, 0xff, 0xff, 0x03,
    0x80, 0x01, 0x78, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define points_width 32
#define points_height 32
static char points_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
    0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
    0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x70, 0x00, 0x00, 0x00, 0x70,
    0x00, 0x00, 0x38, 0x70, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x38, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
    0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x0e, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00,
    0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define right_width 16
#define right_height 16
static char right_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c,
    0x00, 0x1c, 0xfc, 0x3f, 0xfc, 0x7f, 0xfc, 0x3f, 0x00, 0x1c, 0x00, 0x0c,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define shrink_width 16
#define shrink_height 16
static char shrink_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x1f, 0xf0, 0x1f,
    0x10, 0x0c, 0x00, 0x06, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0x60, 0x10,
    0xf0, 0x1f, 0xf0, 0x1f, 0x00, 0x00, 0x00, 0x00
};

#define up_width 16
#define up_height 16
static char up_bits[] = {
    0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f,
    0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03,
    0x80, 0x03, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00
};

#define zoom_width 16
#define zoom_height 16
static char zoom_bits[] = {
    0x00, 0x00, 0x70, 0x00, 0xd8, 0x00, 0x8c, 0x01, 0x06, 0x03, 0x02, 0x02,
    0x06, 0x03, 0x8c, 0x01, 0xd8, 0x03, 0x70, 0x07, 0x00, 0x0e, 0x00, 0x1c,
    0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x00, 0x40
};
