AGE module is different from other tracer modules in that it works with even number of tracers, with the 1st half being the age tracer concentration and the 2nd half being the corresponding ‘ages’ (Shen and Haas 2004). The code hardwires the I.C. flag for this module to be ‘1’, i.e. horizontally variable conditions for all tracers specified in `AGE_hvar_*.ic`. Inside each `.ic` for the 2nd half of tracers, set a uniform 0 at all nodes. For tracers in the 1st half, the user specifies the age concentration to be either 0 or 1, the latter in specific regions where the age tracers will be continuously injected into the domain. For this reason, we suggest setting all B.C. flags for this module to be ‘0’ in `bctides.nml`.

The vertical positions where the age tracers are injected are specified in `param.nml` in the array `level_age(1: ntracer_age/2)`; e.g. for `ntracer_age=4`, we may specify: `level_age = 9, -999` to inject the 1st age tracer at level 9, and the 2nd tracer at all levels (and the code will reset the tracer concentrations to 1 at the same ‘injection’ elements and level(s) at each time step). The output flags for the water ‘age’ in days are specified for half of the total number; e.g., `iof_age(1:2)=1, 0`.